VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Payment"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"32FA94C70287"
'
Implements ObjectControl
Option Base 0
Option Explicit

'set this to 0 to disable debug code in this class

Private mOnlineBankLink As Object
Private oDBaskets As DpkgBaskets.DBaskets

Private oObjectContext As ObjectContext

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = True
End Function

Private Sub ObjectControl_Deactivate()
    Set oObjectContext = Nothing
    Set oDBaskets = Nothing
End Sub

Private Sub ObjectControl_Activate()
    On Error GoTo OCActivateErr
       
    Set oObjectContext = GetObjectContext()
    Set oDBaskets = oObjectContext.CreateInstance("DpkgBaskets.DBaskets")
    Exit Sub

OCActivateErr:
    Call RaiseError("OCActivate")

End Sub

Public Function PostPayment(vOrderID As Variant, vCardNumber As Variant, vCardName As Variant, vCardAmount As Variant, vCardExpireDate As Variant) As Variant
    On Error GoTo PostPaymentErr
    
    Dim query As New MSMQQuery, respQuery As New MSMQQuery
    Dim qinfos As MSMQQueueInfos, qRespInfos As MSMQQueueInfos
    Dim qinfo As MSMQQueueInfo
    Dim q As MSMQQueue
    Dim msg As New MSMQMessage
    
'Find the queue to send the credit request to and open it
    Set qinfos = query.LookupQueue(Label:="Credit Processing Pending")
    qinfos.Reset
    Set qinfo = qinfos.Next
    If qinfo Is Nothing Then
            Set qinfo = New MSMQQueueInfo
        qinfo.PathName = "bf_tecra\CreditProcessingPending"
        qinfo.Label = "Credit Processing Pending"
        qinfo.Create False, True
    End If
   
    Set q = qinfo.Open(MQ_SEND_ACCESS, MQ_DENY_NONE)

    Dim qResponse As MSMQQueueInfo
'Create a queue to send the response to
    Dim strLabel
    strLabel = CStr(vOrderID)
    Set qResponse = New MSMQQueueInfo
    qResponse.PathName = "bf_tecra\CreditResult" & strLabel
    qResponse.Label = "CreditResult" & strLabel
    qResponse.Create False, True
    
    msg.Label = "Credit Processing - Order Num:" & strLabel
    
    Dim strBody
    strBody = "OrderID=" & vOrderID & "&"
    strBody = strBody & "CardNumber=" & vCardNumber & "&"
    strBody = strBody & "CardName=" & vCardName & "&"
    strBody = strBody & "CardAmount=" & vCardAmount & "&"
    strBody = strBody & "CardExpireDate=" & vCardExpireDate

    msg.Body = strBody
    
    Set msg.ResponseQueueInfo = qResponse
    
    msg.Send q

    Dim vResponse As New Collection
    vResponse.Add False, Key:="error"
  
    oObjectContext.SetComplete
    Set PostPayment = vResponse

    Exit Function
PostPaymentErr:
    oObjectContext.SetAbort
    Set PostPayment = RaiseError("PostPayment")
End Function

Public Function ValidateTransactionDetails(ByVal vCustomerId As Variant, ByVal vCardNumber As Variant, ByVal vExpiryDate As Variant, ByVal vTotalPrice As Variant) As Variant
    On Error GoTo ValidateTransactionDetailsErr
    
    Dim vResponse As New Collection
    Dim bInvalid As Boolean
    Dim vInvalidInfo As Variant
    
    bInvalid = False
    vInvalidInfo = ""
    
    Rem *** Not Implemented ***
    Rem Validate card / address /transctions limits using either online
    Rem links to a bank or against a bank supplied validation database
    Rem The following simple validation for test purposes
    If Not vCardNumber = "4444333322221111" Then
        bInvalid = True
        vInvalidInfo = "Unable to authorise card"
    End If
 
    vResponse.Add bInvalid, Key:="invalid"
    vResponse.Add vInvalidInfo, Key:="invalidinfo"
    vResponse.Add False, Key:="error"
  
    oObjectContext.SetComplete
    Set ValidateTransactionDetails = vResponse
    
    Exit Function
    
ValidateTransactionDetailsErr:
    oObjectContext.SetAbort
    Set ValidateTransactionDetails = RaiseError("ValidateTransactionDetails")
    
End Function


